 /******************************************************************************
 CAdaApp.c

				My Application Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 9:22 PM Thu, Aug 5, 1993

	This file is only generated once. You can modify it by filling
	in the placeholder methods and adding any new methods you wish.

	If you change the name of the application, a fresh version of this
	file will be generated. If you have made any changes to the file
	with the old name, you will have to copy those changes to the new
	file by hand.

 ******************************************************************************/

#include "CAdaApp.h"
#include "AppCommands.h"
#include "AdaConstants.h"
#include "ErrMessages.h"
#include "FileNames.h"
#include "CReplace.h"
#include "CTextPane.h"

#include <CDialog.h>
#include <CEditText.h>
#include <CFile.h>
#include <CBartender.h>
#include <Commands.h>
#include <TBUtilities.h>
#include <CDecorator.h>
#include <CDesktop.h>
#include <assert.h>
#include <Processes.h>

#include "AdaGlobals.h"
#include "CAboutBox.h"
#include "CCompilerOptions.h"
#include "CLibrary.h"
#include "CFind.h"
#include "CCompiling.h"
#include "CSourceDocument.h"
#include "CListingDocument.h"
#include "SFGetFolder.h"

//#include "CBkgndTask.h"
#include "CAdaFrontTask.h"
#include "CAdaGenTask.h"
#include "CAdaBindTask.h"
#include "CAdaExecTask.h"

#include "CMemDisplay.h"
#include "CMenuWindow.h"


#include <string.h>						// for strncpy
#include <stdio.h>

extern CBartender	*gBartender;		/* Manages all menus				*/
extern OSType		gSignature;			/* Creator for Application's files	*/
extern Boolean		gInBackground;		/* In background under MultiFinder	*/
extern	CDecorator	*gDecorator;	/* Window dressing object	*/
extern	CDesktop	*gDesktop;		/* The enclosure for all windows */
extern CursHandle	gWatchCursor;		/* Watch cursor for waiting			*/
extern CBureaucrat	*gGopher;			/* First in line to get commands	*/


static Boolean FindByCmd(CObject *obj, long param);
static pascal short myDlogHook(short item, DialogPtr theDialog, Ptr myDataPtr);
static	Boolean HasGestaltAttr(OSType itsAttr, short itsBit);

/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


static Boolean HasGestaltAttr(OSType itsAttr, short itsBit)
{
	long response;
	
	return (Gestalt(itsAttr, &response) == noErr) &&
			(((response >> itsBit) & 1) != 0);
}

/******************************************************************************
 ICAdaApp
 
		Initialize an Application.

	IMPORTANT NOTE: When an object is initialized as part of a
	'CVue' resource, this I-function is NEVER CALLED. Instead,
	the object is initialized in its GetFrom method(s). To add your
	own initialization, override GetFrom.

 ******************************************************************************/

void	CAdaApp::ICAdaApp(void)

{
	long	dummy;
	ProcessSerialNumber psn;
	ProcessInfoRec info;
	FSSpec spec;
	char major, minor;
	long response;


	Ix_CAdaApp(4, 24000L, 20480L, 2048L);
	
		// Initialize your own application data here.
		
	major = HiByte(gSystem.systemVersion);
	minor = LoByte(gSystem.systemVersion);

	if (major < 7) {	// we must have system 7
		ParamText("\pSystem 7.0 (at least) required for this application to run.",
			NULL, NULL, NULL);
		StopAlert(20000, NULL);
		ExitToShell();
	}
	else if (!gSystem.hasAliasMgr) {
		ParamText("\pAlias Manager required for this application to run.",
			NULL, NULL, NULL);
		StopAlert(20000, NULL);
		ExitToShell();
	}
	else if (!gSystem.hasAppleEvents) {
		ParamText("\pApple Events required for this application to run.",
			NULL, NULL, NULL);
		StopAlert(20000, NULL);
		ExitToShell();
	}
	else {
#define HWCfgFlags 0xb22

		if (!HasGestaltAttr(gestaltFSAttr, gestaltHasFSSpecCalls)) {
			ParamText("\pFSSpec calls required for this application to run.",
				NULL, NULL, NULL);
			StopAlert(20000, NULL);
			ExitToShell();
		}

		// this one comes from S. Knaster & K. Rollins book
		if (Gestalt( gestaltAUXVersion, &response) == noErr) {
			if (response != 0) {
				ParamText("\pSorry, this application is not ",
					"\pcompatible with AUX.", NULL, NULL);
				StopAlert(20000, NULL);
				ExitToShell();
			}
		}
		else if (((* (short *) HWCfgFlags) & (1 << 9)) != 0) {
			ParamText("\pSorry, this application is not ",
				"\pcompatible with AUX.", NULL, NULL);
			StopAlert(20000, NULL);
			ExitToShell();
		}

		if (!HasGestaltAttr( gestaltOSAttr, gestaltLaunchControl)) {
			ParamText("\pProcess Manager is required for this application to run.",
				NULL, NULL, NULL);
			StopAlert(20000, NULL);
			ExitToShell();
		}
	}

	// If we make it here means that we have (what appears to be)
	// all the software/hardware requirements to run GWAda...

	winLibrary = NULL;
	dlgFind = NULL;
	backgroundTask = NULL;
	memDisplay = NULL;

	// Read data from Prefs file (later)
		OFCount = 0;
		OFList[0].cmd = cmdOpenFile1;
		OFList[1].cmd = cmdOpenFile2;
		OFList[2].cmd = cmdOpenFile3;
		OFList[3].cmd = cmdOpenFile4;
		OFList[4].cmd = cmdOpenFile5;
		OFList[5].cmd = cmdOpenFile6;
		
		// Find data
		CopyPString("\p", sSearchString);
		CopyPString("\p", sReplaceString);
			
		sFromBeginning = true;
		sLiteralSearch = true;

		openListing = openListingAlways;
		
		executeOptions.exOptSource = false;
		executeOptions.exOptRoutines = false;
		executeOptions.exOptException = false;
		executeOptions.exOptRendezvous = false;
		executeOptions.exOptTask = false;
		executeOptions.exRoundRobin = false;
		executeOptions.exQuantumSize = 5;

	// end of saved data in Prefs


	// State Information at Run Time
	rProcessing = false;
	rHasOpenedDocuments = false;

	if (OFCount == 0)
		gBartender->SetCmdText(OFList[0].cmd, "\pNo Files");

	// set up other global variables
	gAdaApp = this;
	gLibrary = NULL;
	gSource = NULL;

	// Create file manager (CFileMgr)
	gFileMgr = new CFileMgr;
	gFileMgr->IFileMgr();

	// Set application and compiler locations using the CFileMgr class

	psn.highLongOfPSN = 0;
	psn.lowLongOfPSN = kCurrentProcess;		// get info about the current process
	info.processName = NULL;
	info.processAppSpec = &spec;
	info.processInfoLength = sizeof(ProcessInfoRec);

	if (GetProcessInformation(&psn, &info) == noErr) {
		Str255 path;
		FSSpec compiler;
		CInfoPBRec	pb;
		HFileInfo	*fpb = (HFileInfo *)&pb;
		OSErr err;

		gFileMgr->SetApplicationFolder(*(info.processAppSpec));

		// Setup compiler location by reading a relative path
		// form the resource fork and combinind it with the
		// application folder.

		GetIndString(path, 20010, 1);

		fpb->ioFDirIndex = 0;		// this HAS to be 0!
		fpb->ioDirID   = info.processAppSpec->parID;
		fpb->ioVRefNum = info.processAppSpec->vRefNum;
		fpb->ioNamePtr = info.processAppSpec->name;
		err = PBGetCatInfo(&pb, false);

		err = FSMakeFSSpec(fpb->ioVRefNum, //info.processAppSpec->vRefNum
					 fpb->ioFlParID, //info.processAppSpec->parID
					 path,
					 &compiler);

		gFileMgr->SetCompilerFolder(compiler);
	}
	else {
		ParamText("\pInternal Error: GetProcessInformation() failed. ",
			"\pThe application could not be initialized properly.",
			"\p", "\p");
		StopAlert(20000, NULL);
		ExitToShell();
	}
}

/******************************************************************************
 SetUpMenus
 
	Call inherited and then setup the Font/Size menus.  This should
	be done automatically for us, but noooooo.
 ******************************************************************************/

void CAdaApp::SetUpMenus(void)

{

	inherited::SetUpMenus();

		/** Add the fonts in the  system to the	Font menu. **/

	AddResMenu(GetMHandle(MENUfont), 'FONT');

		/**
		 **	The UpdateMenus() method sets up the dimming
		 **	for menu items. By default, the bartender dims
		 **	all the menus, and each bureaucrat is reponsible
		 **	for turning on the items that correspond to the commands
		 **	it can handle.
		 **
		 **	Set up the options here. The edit pane's UpdateMenus()
		 **	method takes care of doing the work.
		 **
		 **	For Font and Size menus, you want all the items to
		 **	be enabled all the time. In other words, you don't
		 **	want the bartender to ever dim any of the items
		 **	in these two menus.
		 **
		 **/

	gBartender->SetDimOption(MENUfont, dimNONE);
	gBartender->SetDimOption(MENUsize, dimNONE);

		/**
		 **	For Font and Size menus, one of the items
		 **	is always checked. Setting the unchecking option
		 **	to TRUE lets the bartender know that it should
		 **	uncheck all the menu items because an UpdateMenus()
		 **	method will check the right items.
		 **	For the Style menu, uncheck all the items and
		 **	let the edit pane's UpdateMenus() method check the
		 **	appropriate ones.
		 **
		 **/

	gBartender->SetUnchecking(MENUfont, TRUE);
	gBartender->SetUnchecking(MENUsize, TRUE);
}

/******************************************************************************
 ForceClassReferences	{OVERRIDE}
 
	Reference classes that do object I/O or are created only
	by new_by_name.
 ******************************************************************************/

void	CAdaApp::ForceClassReferences(void)

{
	Boolean alwaysFalse = FALSE;
	CObject *dummy;

	x_CAdaApp::ForceClassReferences();
	
	if (alwaysFalse)
	{
		// Insert your own class references here, like:
		//
		//	  member(dummy, MyClassName);

		//member(dummy, CListingDocument);
	}
}

/******************************************************************************
 ******************************************************************************/
/**** O P E N   F I L E   L I S T   M E T H O D S ****/
void	CAdaApp::AddFile2OF(SFReply *macReply)
{
	// Store macReply.fsSpec in the list of last opened documents
	// and update menus.


	// Make sure it is not there already.

	if (!IsFileInOF(macReply)) {
		short menuId, itemNo;
		MenuHandle macMenu;
		short putItHere;
		short i;


		// if we didn't find that file in the list, then we will
		// be adding it to the list and to the menu


		// Two cases: (a) list is full, in which case, we move
		// the items up one on the list and store the item at
		// the end.  (b) list is not full, then store the item
		// in the next available slot.
		
		if (OFCount == kNumFiles) {
			// copy all items up one slot
			for (i = 1; i < kNumFiles; i++)
				OFList[i-1].file = OFList[i].file;

			// and put new item at end
			putItHere = kNumFiles - 1;		// last item in array
		}
		else {
			putItHere = OFCount++;			// current slot and inc OFCount
		}


		// first item added does not require adding a menu
		// item because there is a no-name default one already
		// in the menu list.
		if ((putItHere > 0) && (OFCount < kNumFiles)) {
			gBartender->FindMenuItem(OFList[putItHere-1].cmd,
				&menuId, &macMenu, &itemNo);
			gBartender->InsertMenuCmd(OFList[putItHere].cmd,
				macReply->fName, menuId, itemNo);


			// if we later decide to use negative numbers for
			// the menu items (which I think we should), then
			// this is the code that will do the trick.
			//		cmdNo = (-(((long)MENUid) << 16) - itemNo);
			// and here is how to get it back
			//		MENUid = HiShort(-cmdNo);	/* MENU id and LoWord is the item	*/
			//		itemNo = LoShort(-cmdNo);	/* number in the menu				*/


		}

		// and store the sfReply item here
		OFList[putItHere].file = *macReply;


	}
}

/******************************************************************************
 ******************************************************************************/
Boolean	CAdaApp::IsFileInOF(SFReply *macReply)
{
int i;
Boolean foundIt = false;

	for (i = 0; i < OFCount; i++) {
		if ((OFList[i].file.vRefNum == macReply->vRefNum) &&
			(strncmp((char *)&OFList[i].file.fName[1],
					 (char *)&macReply->fName[1],
					(size_t) macReply->fName[0]) == 0)) {
			foundIt = true;
			break;
		}
	}

	return foundIt;
}


/******************************************************************************
 CreateDocument
 
		Make a document in response to the "New" menu selection. This method
		must be overridden if the standard "New" command is used.
 ******************************************************************************/

void	CAdaApp::CreateDocument( void)
{
	CSourceDocument	*theDocument = NULL;

	theDocument = new CSourceDocument;
	TRY
	{
		((CSourceDocument*) theDocument)->ISourceDocument(this, false);
		theDocument->NewFile();
	}
	CATCH
	{
		ForgetObject(theDocument);
	}
	ENDTRY;

}

/******************************************************************************
 OpenDocument
 
		Call the inherited OpenDocument method.  After that executes, add this
		file to the list of Open Files (OF).
 ******************************************************************************/

void	CAdaApp::OpenDocument(SFReply *macReply)
{
	// If Classy was working correctly, then we would let x_CAdaApp
	// handle the open.  But, since it is not, do it here.
	//inherited::OpenDocument(macReply);

	// All text based documents have the same type (TEXT),
	// but some of them will be opened in source documents
	// (if they have an ada extension) and some will be
	// openend in listing documents (no ada extension).
	//
	// 10/3 Change that.  Mike wants them all the same type,
	// if a "user" is stupid enougth to compile a listing file
	// then that's their problem.  So, make all Text Documents
	// class CSourceDocument.
	//

			/* Only the application knows		*/
	if (FsAlreadyOpen(macReply))		// if open, then select it
		Failure(kSilentErr, 0);


	if (macReply->fType == kTextSource) {
		Str255	fileName, ext;
		
		CopyPString(macReply->fName, fileName);
		ParseFile(fileName, flExtension, ext);
		Lowercase(ext);

		if (IUEqualString(ext, "\p.lis") == 0) {
			// create a Listing file (no edit allowed) but flag
			// it somehow that it doesn't need to do any listing
			// functions...
			CListingDocument	*theDocument = NULL;

			FailNIL( theDocument = new CListingDocument );
			TRY {

				if (gSource) {
					theDocument->IListingDocument(gSource,
						gSource->GetNumErrors(),
						gSource->GetErrorMsgs());
					gSource->ConnectListing(theDocument);

					//if (member(gGopher, CDirector)) {
					//	((CDirector *)gGopher)->Suspend();
					//}
					//theDocument->BecomeGopher(true);
					//gSource->BecomeGopher(true);

					gSource = NULL;
				}
				else
					theDocument->IListingDocument(NULL, 0, NULL);
				theDocument->OpenFile(macReply);
			}
			CATCH {
				ForgetObject(theDocument);
			}
			ENDTRY;
		}

		else {
			CSourceDocument	*theDocument = NULL;

			FailNIL (theDocument = new CSourceDocument);
			TRY {
				theDocument->ISourceDocument(this, false);
				theDocument->OpenFile(macReply);
			}
			CATCH {
				ForgetObject(theDocument);
			}
			ENDTRY;
		}
		AddFile2OF(macReply);

	}
}


/******************************************************************************
 FileAlreadyOpen

	If file already in use return TRUE and bring owning document's
	window to the foreground.  Sent from document before opening.
 ******************************************************************************/

	static Boolean EqualFs(CObject *obj, long param)
	{
		FSSpec		theFileSpec;
		CFile		*theFile;
		FSSpec		*theParam = (FSSpec*) param;

		if (member(obj, CDocument))
		{
			theFile = ((CDocument*)obj)->itsFile;
			if (theFile == NULL)
				return FALSE;
			theFile->GetFSSpec(&theFileSpec);
			return theFileSpec.vRefNum == theParam->vRefNum
				&& theFileSpec.parID == theParam->parID
				&& !IUEqualString(theFileSpec.name, theParam->name);
		}
		return FALSE;
	}

Boolean CAdaApp::FsAlreadyOpen(SFReply *macReply)

{
	CDirector	*theDirector = NULL;

	short	aVolNum;
	long	aDirID;
	long	aProcID;
	FSSpec	fileSpec;
													
	FailOSErr( GetWDInfo(macReply->vRefNum, &aVolNum, &aDirID, &aProcID));
	CopyPString(macReply->fName, fileSpec.name);
	fileSpec.vRefNum = aVolNum;
	fileSpec.parID = aDirID;
	


	if (itsDirectors)						/* Search for matching file		*/
		theDirector = (CDirector*) itsDirectors->FindItem1(EqualFs, (long) &fileSpec);
	if (theDirector)						/* If find one, bring to front	*/
		theDirector->GetWindow()->Select();
	return theDirector != NULL;				/* Tell caller					*/
}

/**** C O M M A N D   M E T H O D S ****/

/******************************************************************************
 UpdateMenus {OVERRIDE}

		Enable menus which generate commands handled by this class.
 ******************************************************************************/

void CAdaApp::UpdateMenus(void)

{
	MenuHandle menu;
	short count;
	register short i;
	register long cmdNo;

	x_CAdaApp::UpdateMenus();

	// Open Menu items
	if (OFCount > 0)
		gBartender->EnableCmd(cmdOpenOther);
	else
		gBartender->DisableCmd(cmdOpenOther);

	// Enable/Disable command names from previous opened source files.
	for (i = 0; i < OFCount; i++) {
		gBartender->EnableCmd(OFList[i].cmd);
		gBartender->SetCmdText(OFList[i].cmd, OFList[i].file.fName);
	}

	for (; i < kNumFiles; i++)
		gBartender->DisableCmd(OFList[i].cmd);

	// if we have at least one document opened
	// and the document window is the front most
	// then enable Find.  But, if we have at least
	// one document opened, then the document will
	// get a chance at enabling/disabling the menus
	// after we do this... so just disable anything
	// that is dependent on documents.

	gBartender->DisableCmd(cmdFind);
	gBartender->DisableCmd(cmdEnterSelection);
	gBartender->DisableCmd(cmdFindAgain);
	gBartender->DisableCmd(cmdReplace);
	//gBartender->DisableCmd(cmdReplaceAll);
	gBartender->DisableCmd(cmdReplaceFindAgain);
	
	gBartender->DisableCmd(cmdGotoLine);

	gBartender->SetCmdText(cmdBindOne, "\pBind");
	gBartender->SetCmdText(cmdExecuteOne, "\pExecute");
	gBartender->DisableCmd(cmdBindOne);
	gBartender->DisableCmd(cmdExecuteOne);

	if (!winLibrary) {
		gBartender->DisableCmd(cmdWLibrary);
		gBartender->EnableCmd(cmdOpenLibrary);
		gBartender->DisableCmd(cmdCloseUserLibrary);

		// enable all submenus of cmdBindOther
		//gBartender->DisableMenu(kBindOtherMenu);
		gBartender->DisableCmd(cmdBindOther);
		menu = gBartender->FindMacMenu(kBindOtherMenu);
		count = CountMItems(menu);
		for (i = 1; i <= count; i++)
			gBartender->DisableCmd((-(((long)kBindOtherMenu) << 16) - i));

		// enable all submenus of cmdExecuteOther
		//gBartender->DisableMenu(kExecuteOtherMenu);
		gBartender->DisableCmd(cmdExecuteOther);
		menu = gBartender->FindMacMenu(kExecuteOtherMenu);
		count = CountMItems(menu);
		for (i = 1; i <= count; i++)
			gBartender->DisableCmd((-(((long)kExecuteOtherMenu) << 16) - i));


	}
	else {

		gBartender->EnableCmd(cmdWLibrary);

		gBartender->DisableCmd(cmdOpenLibrary);
		gBartender->EnableCmd(cmdCloseUserLibrary);

		// enable all submenus of cmdBindOther
		//gBartender->EnableMenu(kBindOtherMenu);
		gBartender->EnableCmd(cmdBindOther);
		menu = gBartender->FindMacMenu(kBindOtherMenu);
		count = CountMItems(menu);
		for (i = 1; i <= count; i++)
			gBartender->EnableCmd((-(((long)kBindOtherMenu) << 16) - i));

		// enable all submenus of cmdExecuteOther
		//gBartender->EnableMenu(kExecuteOtherMenu);
		gBartender->EnableCmd(cmdExecuteOther);
		menu = gBartender->FindMacMenu(kExecuteOtherMenu);
		count = CountMItems(menu);
		for (i = 1; i <= count; i++)
			gBartender->EnableCmd((-(((long)kExecuteOtherMenu) << 16) - i));

	}

	menu = gBartender->FindMacMenu(133);
	count = CountMItems(menu);
	for (i = 3; i <= count; i++)		// 1 == User lib, 2 == \---
		gBartender->EnableCmd((-(((long)133) << 16) - i));

#ifdef STUFF
	
	// Once a find is issued, then enable these
	gBartender->EnableCmd(cmdFindAgain);

	// If the text search engine has a replace text
	//gBartender->EnableCmd(cmdReplaceAll);

	// and we already did one successful find then
	gBartender->EnableCmd(cmdReplace);
	gBartender->EnableCmd(cmdReplaceFindAgain);

#endif

}


/******************************************************************************
 DoCommand	{OVERRIDE}

	Handle application commands
 ******************************************************************************/

	static Boolean FindByCmd(CObject *obj, long param)
	{
		CMenuWindow *win = (CMenuWindow *)obj;
		
		if (member(obj, CMenuWindow))
			return (win->GetCmdNo() == param);
		else
			return false;
	}

void CAdaApp::DoCommand(long theCommand)

{

	switch (theCommand)
	{
		case cmdNewUserLibrary: {
			DoCmdNewLibrary();
			break;
		}

		case cmdAbout: {
			// Respond to command by opening a dialog
			CAboutBox		*dialog;

		
			dialog = new CAboutBox;
			dialog->ICAboutBox(this);
			dialog->BeginDialog();
		
											/* cmdOK is usually right, but the		*/
			dialog->DoModalDialog(cmdOK);	/*	 but dialog itself may know better	*/
			ForgetObject(dialog);
			break;
		}


		case cmdCompileOther: {
			SFReply macReply;

			ChooseFile(&macReply);
			if (macReply.good) {
				CSourceDocument	*theDocument = NULL;


				SetCursor(*gWatchCursor);

				// Compile...  Create a class CSource, which will be
				// a parent of CSourceDocument.  CSource has no window
				// until it is compiled.  The window will opened only
				// if there are errors...

				theDocument = new CSourceDocument;
				TRY {

					theDocument->ISourceDocument(this, true);
					theDocument->OpenFile(&macReply);

					AddFile2OF(&macReply);

					Compile(theDocument);
				}
				CATCH {
					ForgetObject(theDocument);
				}
				ENDTRY;


			}
			break;
		}


		case cmdCompileOptions: {
				// Get Compile options
			CCompilerOptions *copt;
			
			copt = new CCompilerOptions;
			copt->ICCompilerOptions(this);
			copt->BeginDialog();
			
			copt->DoModalDialog(cmdOK);
			ForgetObject(copt);
			break;
		}

		case cmdWLibrary:
			assert(winLibrary);
			assert(winLibrary->itsWindow);
			winLibrary->itsWindow->Select();
			break;

		case cmdOpenFile1:
		case cmdOpenFile2:
		case cmdOpenFile3:
		case cmdOpenFile4:
		case cmdOpenFile5:
		case cmdOpenFile6: {
			short menuId, itemNo;
			MenuHandle macMenu;

			gBartender->FindMenuItem(theCommand,
				&menuId, &macMenu, &itemNo);
			OpenDocument(&OFList[itemNo-1].file);
			break;
		}

#ifdef ShowMemory
		case cmdMemory: {
			
			if (memDisplay == NULL) {
				CMemDisplay	*aDisplay;
				CDirector *aDirector;
				Rect	bounds;
			
				SetRect(&bounds, 100, 100, 200, 150);
				aDirector = new(CDirector);
				aDirector->IDirector(this);
				memDisplay = new(CWindow);
				memDisplay->INewWindow(&bounds, FALSE, 0, FALSE,
					FALSE, gDesktop, aDirector);

				aDisplay = new(CMemDisplay);
				aDisplay->IMemDisplay(memDisplay, aDirector);
				aDisplay->FitToEnclFrame(TRUE, TRUE);
				memDisplay->Show();
				memDisplay->Select();
			}
			else
				memDisplay->Select();
			break;
		}
#endif

		default:
			if (theCommand < 0) {		// negative number is menu w/o command #
				short menuId;
				short menuItem;
				Str255 cmdText;
				
				gBartender->GetCmdText(theCommand, cmdText);
				menuId = HiShort(-theCommand);
				menuItem = LoShort(-theCommand);
				
				if (menuId == kBindOtherMenu)			// bind
					Bind(cmdText);
				else if (menuId == kExecuteOtherMenu)		// execute
					Execute(cmdText);

				else if (menuId == 133) {
					CMenuWindow	*theWindow;
					CList *itsList;
				
					// Search itsWindow list for a window with this command number
					itsList = gDesktop->itsWindows;
					theWindow = (CMenuWindow *)itsList->FindItem1(FindByCmd, theCommand);

					if (theWindow) {
						if (!theWindow->ReallyVisible())
							theWindow->Show();
					
						theWindow->Select();
					}
				}
				else
					x_CAdaApp::DoCommand(theCommand);

			}
			else
				x_CAdaApp::DoCommand(theCommand);
			break;
	}
}

/******************************************************************************
 DoCmdNewLibrary

		Respond to cmdNewLibrary command.
		Put up a standard put file dialog box to allow the user to
		specify a new name under which to put the library.
 ******************************************************************************/

	static pascal short myDlogHook(short item, DialogPtr theDialog, Ptr myDataPtr)
	{
		Handle hdl;
		short type;
		Rect rect;

		if (GetWRefCon((WindowPtr)theDialog) != sfMainDialogRefCon)
			return item;
		else {
			switch (item) {
				case sfHookFirstCall:
					/* Set button title and do nothing */
					GetDItem(theDialog, sfItemOpenButton, &type, &hdl, &rect);
					SetCTitle((ControlHandle)hdl, "\pCreate");
					return sfHookNullEvent;
				default:
					return item;
			}
		}
	}

void CAdaApp::DoCmdNewLibrary(void)
{
	StandardFileReply	stdReply;
	OSErr	err;
	Str255	fileName;
	long	createdDirID;
	Point where = {-1, -1};

	// do an sfputfile with prompt "Create a new user library here:"
	// and default file name "My Lib"

	CustomPutFile("\pCreate a New User Library:", "\pMy Library",
		&stdReply, 0, where, (DlgHookYDProcPtr)myDlogHook, NULL, NULL, NULL, NULL);

	// if everything is ok
	if (stdReply.sfGood && !stdReply.sfReplacing) {

		/* create a folder */
		err = DirCreate(stdReply.sfFile.vRefNum, stdReply.sfFile.parID, stdReply.sfFile.name, &createdDirID);

		gLibrary = NULL;
		winLibrary = new CLibrary;
		gLibrary = winLibrary;
		TRY
		{
			gFileMgr->SetLibraryFolder(stdReply.sfFile);
			winLibrary->ICLibrary(stdReply.sfFile);
			winLibrary->NewLibrary();
		}
		CATCH
		{
			ForgetObject(winLibrary);
			winLibrary = NULL;
		}
		ENDTRY;
	}
	else if (stdReply.sfGood && stdReply.sfReplacing) {
		StopAlert(20050, NULL);
	}
}

/******************************************************************************
 DoCmdOpenLibrary

		Respond to cmdOpenLibrary command.
 ******************************************************************************/

void CAdaApp::DoCmdOpenLibrary(void)
{
FSSpec spec;

	if (SelectLibrary(&spec)) {

#ifdef GOOD_BUT_UNUSED
		FSSpec		currDoc;
		Str255		fullName;
		Boolean		newLib;
		MenuHandle	menu;
		OSErr		err;
		FInfo		fileInfo;
		short 		wdRefNum;
		SFReply		macReply;
	// this code was in good condition, but it is unused
		FailOSErr(err);
		FailOSErr( OpenWD( currDoc.vRefNum, currDoc.parID,
						gSignature, &wdRefNum));

		FailOSErr( FSpGetFInfo( &currDoc, &fileInfo));
		
		macReply.good = TRUE;				// this is important to set here
		macReply.vRefNum = wdRefNum;
		macReply.fType = fileInfo.fdType;
		macReply.version = macReply.copy = 0;
		CopyPString( currDoc.name, macReply.fName);
#endif

		gLibrary = NULL;
		winLibrary = new CLibrary;
		gLibrary = winLibrary;
		TRY
		{
			MenuHandle menu;

			gFileMgr->SetLibraryFolder(spec);
			winLibrary->ICLibrary(spec);
			winLibrary->OpenLibrary();

			// once the library is opened, then find the menu
			// for binding and executing and rebuild it from the
			// contents of the library.

			menu = gBartender->FindMacMenu(kBindOtherMenu);
			winLibrary->BuildBindMenu(menu);

			menu = gBartender->FindMacMenu(kExecuteOtherMenu);
			winLibrary->BuildExecuteMenu(menu);

		}
		CATCH
		{
			ForgetObject(winLibrary);
			winLibrary = NULL;
		}
		ENDTRY;
	}
}

/******************************************************************************
 LibraryClosed

		The library was closed, mark things accordingly here.
 ******************************************************************************/

void	CAdaApp::LibraryClosed(void)
{
	winLibrary = NULL;
	gLibrary = NULL;
}

/******************************************************************************
 SelectLibrary

	Open dialogue and let user select new library
 ******************************************************************************/
Boolean	CAdaApp::SelectLibrary(FSSpec *spec)
{
	// This will get a folder
	return (SFGetFolder(spec, "\pSelect User Library:", "\pMy Library"));
}

/****
 *	GetUserLibrary
 *
 ****/

CLibrary	*CAdaApp::GetUserLibrary(void)
{
	return winLibrary;
}


/******************************************************************************
 Compile
 
 Force a save, find FSSpec, and launch compiler.
 ******************************************************************************/
void	CAdaApp::Compile(CSourceDocument *document)
{

	// Compiling has two prerequisites:  the document
	// must be saved, and the user library must be
	// selected.  Check the library first, and then the
	// source file.
	
	// if we don't have a library selected
	if (!winLibrary) {
		short id;
		
		id = StopAlert(20010, NULL);
		if (id == 1)
			DoCmdOpenLibrary();
		else if (id == 3)
			DoCmdNewLibrary();
	}


	// if we still don't have a library selected, then get
	// out.
	if (!winLibrary)
		return;			// GET OUT OF HERE!!!



	// Force a save before we go on
	if (document->dirty)
		document->DoSave();

	// if everything went well, then
	if (!document->dirty) {
	
		CAdaFrontTask *front = NULL;
		CAdaGenTask *gen = NULL;
		FSSpec spec;


		document->GetFSSpec(&spec);
		gFileMgr->SetSource(spec);
		backgroundTask = NULL;
		rProcessing = false;

		TRY {
			// startup the compiler here
			FailNIL( front = new CAdaFrontTask );
			//front->IAdaFrontTask(document, path);
			front->IAdaFrontTask(document);

			FailNIL( gen = new CAdaGenTask );
			//gen->IAdaGenTask(document, path);
			gen->IAdaGenTask(document);

			front->SetNext(gen);
			backgroundTask = front;
			backgroundTask->StartRunning();
			rProcessing = backgroundTask->StillRunning();
		}
		CATCH {
			ForgetObject(front);
			ForgetObject(gen);
			backgroundTask = NULL;
			rProcessing = false;
		}
		ENDTRY;
	}
}

/******************************************************************************
 Bind

	Call the background binding process
 ******************************************************************************/
void	CAdaApp::Bind(Str255 MainProgram)
{
	//Str255 path;
	CAdaBindTask *bind = NULL;
	
	// if we don't have a library selected, we shouldn't be here!
	assert(winLibrary);


	// Setup predef path
	//GetIndString(path, 20010, 1);
	
	gFileMgr->SetUnitName(MainProgram);
	backgroundTask = NULL;
	rProcessing = false;

	TRY {
		// startup the binder here
		FailNIL( bind = new CAdaBindTask );
		//bind->IAdaBindTask(path, MainProgram);
		bind->IAdaBindTask(MainProgram);

		backgroundTask = bind;
		backgroundTask->StartRunning();
		rProcessing = backgroundTask->StillRunning();
	}
	CATCH {
		ForgetObject(bind);
		rProcessing = false;
		backgroundTask = NULL;
	}
	ENDTRY;
}

/******************************************************************************
 Execute

	Call the background monitor
 ******************************************************************************/
void	CAdaApp::Execute(Str255 BindingUnit)
{
	//Str255 path;
	CAdaExecTask *exec;
	
	// if we don't have a library selected, we shouldn't be here!
	assert(winLibrary);

	// Setup predef path
	//GetIndString(path, 20010, 1);

	gFileMgr->SetUnitName(BindingUnit);
	backgroundTask = NULL;
	rProcessing = false;

	TRY {
		// startup the monitor here
		exec = new CAdaExecTask;
		//exec->IAdaExecTask(path, BindingUnit);
		exec->IAdaExecTask(BindingUnit);

		backgroundTask = exec;
		backgroundTask->StartRunning();
		rProcessing = backgroundTask->StillRunning();
	}
	CATCH {
		ForgetObject(exec);
		rProcessing = false;
		backgroundTask = NULL;
	}
	ENDTRY;
}

/******************************************************************************
 Dawdle

	Processing while idle.  This checks for background processes, and
	when they are finished, we take appropriate action.
 ******************************************************************************/

void	CAdaApp::Dawdle(long *maxSleep)
{
	inherited::Dawdle(maxSleep);

#ifdef OLD_ONE
	if (rProcessing && backgroundTask) {

		(*maxSleep) = 30;		/* 30 ticks = 1/2 second */
		if (!backgroundTask->StillRunning()) {
			short errs;

			errs = backgroundTask->ReadCompletionCode();
			if (errs == 0) {
				CBkgndTask *p;

				if ((p = backgroundTask->GetNext()) != NULL) {

					// If we have another task pending, then delete
					// the one that just finished...
					
					TRY {
						backgroundTask->Cleanup();
						backgroundTask->Dispose();	// delete current
					}
					CATCH {
						ForgetObject(backgroundTask);
					}
					ENDTRY;

					// ... and start the next one
					backgroundTask = p;
					TRY {
						backgroundTask->StartRunning();
						rProcessing = backgroundTask->StillRunning();
					}
					CATCH {
						ForgetObject(p);
						rProcessing = false;
						backgroundTask = NULL;
					}
					ENDTRY;
				}


				else { /* (p == NULL) */
					// We don't have another process to run, so
					// update the user library (if neccessary) and
					// finish background processing

					TRY {
						backgroundTask->Cleanup();
						backgroundTask->Dispose();	// delete current
					}
					CATCH {
						ForgetObject(backgroundTask);
						backgroundTask = NULL;
					}
					ENDTRY;
					rProcessing = false;
				}
			}
			
				// Error Processing: call the background task object
				// to do whatever is appropriate.
			else {
				CBkgndTask *p, *save;

				// Get the next (pending) bkgdn task
				save = backgroundTask->GetNext();

				// break the link here
				backgroundTask->SetNext(NULL);

				// and cleanup the one that just finished with errors
				TRY {
					backgroundTask->Cleanup();
					backgroundTask->Dispose();
				}
				CATCH {
					ForgetObject(backgroundTask);
				}
				ENDTRY;
				backgroundTask = NULL;


				// now, get rid of all pending tasks
				while (save) {
					p = save->GetNext();
					save->Dispose();		// don't call Cleanup()
					save = p;
				}

				rProcessing = false;
			}
		}
	}
#endif
}

/******************************************************************************
 ******************************************************************************/
void	CAdaApp::StartingBkgnd(void)
{
}

/******************************************************************************
 ******************************************************************************/
void	CAdaApp::FinishedBkgnd(short alertId, Boolean noteAlert)
{
	if (noteAlert)
		NoteAlert(alertId, NULL);
	else
		CautionAlert(alertId, NULL);
}

/******************************************************************************
 Resume
 
		Program is being swapped in under MultiFinder
 ******************************************************************************/
	
void	CAdaApp::Resume( void)
{
	inherited::Resume();

	if (rProcessing && backgroundTask) {
		if (!backgroundTask->StillRunning()) {
			short errs;

			errs = backgroundTask->ReadCompletionCode();
			if (errs == 0) {
				CBkgndTask *p;

				if ((p = backgroundTask->GetNext()) != NULL) {

					// If we have another task pending, then delete
					// the one that just finished...
					
					TRY {
						backgroundTask->Cleanup();
						backgroundTask->Dispose();	// delete current
					}
					CATCH {
						ForgetObject(backgroundTask);
					}
					ENDTRY;

					// ... and start the next one
					backgroundTask = p;
					TRY {
						backgroundTask->StartRunning();
						rProcessing = backgroundTask->StillRunning();
					}
					CATCH {
						ForgetObject(p);
						rProcessing = false;
						backgroundTask = NULL;
					}
					ENDTRY;
				}


				else { /* (p == NULL) */
					// We don't have another process to run, so
					// update the user library (if neccessary) and
					// finish background processing

					TRY {
						backgroundTask->Cleanup();
						backgroundTask->Dispose();	// delete current
					}
					CATCH {
						ForgetObject(backgroundTask);
						backgroundTask = NULL;
					}
					ENDTRY;
					rProcessing = false;
				}
			}
			
				// Error Processing: call the background task object
				// to do whatever is appropriate.
			else {
				CBkgndTask *p, *save;

				// Get the next (pending) bkgdn task
				save = backgroundTask->GetNext();

				// break the link here
				backgroundTask->SetNext(NULL);

				// and cleanup the one that just finished with errors
				TRY {
					backgroundTask->Cleanup();
					backgroundTask->Dispose();
				}
				CATCH {
					ForgetObject(backgroundTask);
				}
				ENDTRY;
				backgroundTask = NULL;


				// now, get rid of all pending tasks
				while (save) {
					p = save->GetNext();
					save->Dispose();		// don't call Cleanup()
					save = p;
				}

				rProcessing = false;
			}
		}
	}
}


/******************************************************************************
 ******************************************************************************/
// Search Management
void	CAdaApp::SetSearchString(Str255 s)
{
	CopyPString(s, sSearchString);
}

/******************************************************************************
 ******************************************************************************/
void	CAdaApp::SetSearchOptions(Str255 s, Str255 r,
			Boolean startFrom, Boolean searchType)
{
	CopyPString(s, sSearchString);
	CopyPString(r, sReplaceString);

	sFromBeginning = startFrom;
	sLiteralSearch = searchType;
}

/******************************************************************************
 ******************************************************************************/
void	CAdaApp::GetSearchOptions(Str255 *s, Str255 *r,
			Boolean *startFrom, Boolean *searchType)
{

	CopyPString(sSearchString, *s);
	CopyPString(sReplaceString, *r);

	*startFrom = sFromBeginning;
	*searchType = sLiteralSearch;
}

/****
 * Search
 *
 *	Search for string in the current document starting at the
 *	current line.
 ****/
Boolean	CAdaApp::Search(CTextDocument *doc, long searchCmd)
		// Search in this textEdit field,  move the
		// insertion point and scroll if needed
{
long iOffset, offset, findLen, rplcLen, dummy;
Handle destStrH;
Ptr findStr, rplcStr;
CTextPane *editText;

	// This is commented out for now.  No support for search
	// from beginning of file, for now we always start search
	// from the current location of the cursor
	// if ((searchCmd == cmdFindAgain) || (!sFromBeginning)) {

	editText = doc->fTextEdit;
	editText->GetSelection(&dummy, &offset);

	// if no insertion point, then beep and finish
	if (offset == editText->GetLength()) {
		SysBeep(1);
		return false;
	}

	else {

		destStrH = editText->GetTextHandle();
		findStr = (char *)&sSearchString[1];
		findLen = sSearchString[0];
		rplcStr = NULL;
		rplcLen = 0;
		iOffset = Munger(destStrH, offset, findStr, findLen,
										   rplcStr, rplcLen);
		if (iOffset < 0)
			SysBeep(1);
		else {
			editText->SetSelection(iOffset, iOffset+findLen, true);
			editText->ScrollToSelection();
		}

		return (iOffset > 0);
	}
}

/****
 * Replace
 *
 *	Replace current selection, and (optional) find again.
 *
 ****/
Boolean	CAdaApp::Replace(CTextDocument *doc, long replaceCmd)
		// replace command using current selection and sReplaceString
{
long iOffset, selStart, selEnd, findLen, rplcLen;
Handle destStrH;
Ptr findStr, rplcStr;
Boolean result;
CTextPane *editText;
CReplace *replaceTask;


	replaceTask = new (CReplace);
	replaceTask->IReplace(doc, sReplaceString);

	editText = doc->fTextEdit;
	editText->GetSelection(&selStart, &selEnd);

	editText->TypeChar(0x08, 0);		/* backspace */
	editText->InsertTextPtr((Ptr)&sReplaceString[1],
		sReplaceString[0], true);

	if (replaceCmd == cmdReplaceFindAgain)
		result = Search(doc, cmdFindAgain);
	else
		result = false;

	editText->ScrollToSelection();

	doc->Notify(replaceTask);
	return result;
}

/******************************************************************************
 ******************************************************************************/
void	CAdaApp::SetOptions(Boolean  showLis)
{
	openListing = showLis;
}

/******************************************************************************
 ******************************************************************************/
void	CAdaApp::GetOptions(Boolean *showLis)
{
	*showLis = openListing;
}

/******************************************************************************
 ******************************************************************************/
void	CAdaApp::SetExOptions(ExOptions options)
{
	executeOptions = options;
}

/******************************************************************************
 ******************************************************************************/
void	CAdaApp::GetExOptions(ExOptions *options)
{
	*options = executeOptions;
}

/******************************************************************************
 ******************************************************************************/
// Given a command, can we execute it in the current context?
Boolean	CAdaApp::CanCmd(long command)
{
	switch(command) {
		case cmdFind:
			return true;		// only if we have a doc opened
			break;
	
		case cmdFindAgain:
			return (sSearchString[0] > 0);
			break;

		case cmdReplace:
		//case cmdReplaceAll:
			return (sReplaceString[0] > 0);
			break;

		case cmdReplaceFindAgain:
			return ((sReplaceString[0] > 0) && (sSearchString[0] > 0));
			break;
	}
	return false;
}

/******************************************************************************
 GetDocTypeFromDialog

	Get the document type from the dialog. If you have multiple
	document types, you must override this function to extract
	the type from the dialog state. (The dialog has been executed
	and OK'd by the user.) If you do not have multiple document
	types, you can remove this function.
 ******************************************************************************/

OSType CAdaApp::GetDocTypeFromDialog(CDialogDirector *dialog)

{
	return 0;
}
